
%% Matlab Code for generating breath noise in the range of -10 to 10 dB in steps of 1 dB and 201 test signals for each SNR
clc;
close all;
%% Load healthy person lung sound file here
load posterior_right
Healthy_person_sound        = data(1:end);
%% Load 10 identical simulated ATS fine crackles here 
load SF1_ATS
load SF2_ATS
load SF3_ATS
load SF4_ATS
load SF5_ATS
load SF6_ATS
load SF7_ATS
load SF8_ATS
load SF9_ATS
load SF10_ATS
fs              = 44100;                                                       %% Sampling frequency
Signal_length   = 32768;                                                       %% Signal length
%% Make the length equal
SF1_ATS         = [zeros(1,1000),SF1_ATS,zeros(1,Signal_length-(1000+length(SF1_ATS)))];
SF2_ATS         = [zeros(1,3000),SF2_ATS,zeros(1,Signal_length-(3000+length(SF2_ATS)))];
SF3_ATS         = [zeros(1,7000),SF3_ATS,zeros(1,Signal_length-(7000+length(SF3_ATS)))];
SF4_ATS         = [zeros(1,12000),SF4_ATS,zeros(1,Signal_length-(12000+length(SF4_ATS)))];
SF5_ATS         = [zeros(1,14000),SF5_ATS,zeros(1,Signal_length-(14000+length(SF5_ATS)))];
SF6_ATS         = [zeros(1,17000),SF6_ATS,zeros(1,Signal_length-(17000+length(SF6_ATS)))];
SF7_ATS         = [zeros(1,20000),SF7_ATS,zeros(1,Signal_length-(20000+length(SF7_ATS)))];
SF8_ATS         = [zeros(1,23000),SF8_ATS,zeros(1,Signal_length-(23000+length(SF8_ATS)))];
SF9_ATS         = [zeros(1,27500),SF9_ATS,zeros(1,Signal_length-(27500+length(SF9_ATS)))];
SF10_ATS        = [zeros(1,30000),SF10_ATS,zeros(1,Signal_length-(30000+length(SF10_ATS)))];
Ten_identical_simulated_ATS_fine_crackles       = SF1_ATS+SF2_ATS+SF3_ATS+SF4_ATS+SF5_ATS+SF6_ATS+SF7_ATS+SF8_ATS+SF9_ATS+SF10_ATS;
Ten_identical_simulated_ATS_fine_crackles       = Ten_identical_simulated_ATS_fine_crackles(1:end);
%% Preallocate variables here


%% Start SNR and Iterative loops
for SNR_loop            = -10:1:10                                          %% Start signal to noise ratio loop
for iterative_loop      = 1:201                                             %% Start number of iterations loop 
%% Autoregressive model to generate breath noise
[p,e]           = armcov(Healthy_person_sound, 10);                         %% Autoregressive model for generating breath noise
breath_noise    = filter(1,p,randn(1,Signal_length)); 
%% Calculate scaling factor for changing the signal to noise ratio
Crackle_power   = sum(abs(Ten_identical_simulated_ATS_fine_crackles).*abs(Ten_identical_simulated_ATS_fine_crackles))/Signal_length;                          
Noise_Power     = sum(abs(breath_noise).*abs(breath_noise))/Signal_length;
Scaling_factor  = (Crackle_power/Noise_Power)*10^(-SNR_loop/10);  
Signal          = sqrt(Scaling_factor)*breath_noise+Ten_identical_simulated_ATS_fine_crackles;  %% Signal with 10 identical ATS fine crackles buried under breath noise

%% Use your separation technique here



end
end